/** @file   LightballAi.h
 * @brief   Declaration of LightballAi class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:41 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_LIGHTBALLAI_H
#define H_WWW_LIGHTBALLAI_H

#include "aicontroller.h"

namespace WeWantWar {

/** @class  LightballAi
 * @brief   Contains the logic that controls the LightballAlien
 * @author  Tomi Lamminsaari
 *
 */
class LightballAi : public AIController
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   * @param   aObject           Pointer to GameObject whom we are controlling.
   */
  LightballAi( GameObject* aObject );

  /** Destructor
   */
  ~LightballAi();

private:
  
  /** Copy constructor
   * @param   aAnother          Reference to another LightballAi
   */
  LightballAi( const LightballAi& aAnother );

  /** An assignment operator
   * @param   aAnother          Reference to another LightballAi
   * @return  Reference to this object.
   */
  LightballAi& operator= ( const LightballAi& aAnother );

public:

  ///
  /// Inherited methods
  /// =================

  /** Updates this controller.
   * @param   aSeeTarget        Tells if we can see our target.
   * @param   aDistance         Distance to our target.
   */
  virtual void updateAI( bool aSeeTarget, float aDistance );

  ///
  /// New public methods
  /// ==================


  ///
  /// Getter methods
  /// ==============


protected:
  ///
  /// Protected interface
  /// ===================


protected:
  ///
  /// Data members
  /// ============

  /** Tells if we're in alerted mode. */
  bool      iAlerted;
  
  /** THe previous player position is stored here. */
  eng2d::Vec2D  iLastKnownPos;
};

};  // end of namespace

#endif
